/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.entitysyncer.structured;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.openzen.entitysyncer.live.field.LiveField;
import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.structured.definition.StructuredFieldDefinition;
import org.openzen.entitysyncer.structured.definition.StructuredObjectClass;

public abstract class BaseStructuredObject
implements StructuredObject {
    private final UUID id;
    private ObjectFields fields = null;

    public BaseStructuredObject(UUID id) {
        this.id = id;
    }

    protected final void initNew() {
        this.fields = this.create(this.getStructuredClass());
    }

    protected final void initFrom(StructuredDataInputStream input) {
        this.fields = this.read(this.getStructuredClass(), input);
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public LiveField getField(UUID clsid, int index) {
        return this.fields.get(clsid, index);
    }

    private ObjectFields create(StructuredObjectClass cls) {
        ObjectFields parent = null;
        if (cls.superclass != null) {
            parent = this.create(cls.superclass);
        }
        ArrayList<LiveField> fields = new ArrayList<LiveField>();
        for (StructuredFieldDefinition field : cls.getFields()) {
            while (field.id <= fields.size()) {
                fields.add(null);
            }
            LiveField liveField = this.getField(cls.id, field.id);
            fields.set(field.id, liveField == null ? field.type.create() : liveField);
        }
        return new ObjectFields(cls.id, fields, parent);
    }

    private ObjectFields read(StructuredObjectClass cls, StructuredDataInputStream input) {
        ObjectFields parent = null;
        if (cls.superclass != null) {
            parent = this.read(cls.superclass, input);
        }
        ArrayList<LiveField> fields = new ArrayList<LiveField>();
        for (StructuredFieldDefinition field : cls.getFields()) {
            while (field.id <= fields.size()) {
                fields.add(null);
            }
            LiveField liveField = this.getField(cls.id, field.id);
            fields.set(field.id, liveField == null ? field.type.create() : liveField);
        }
        long fieldsMask = input.input.readVarULong();
        int index = 0;
        for (StructuredFieldDefinition field : cls.getFields()) {
            long fieldMask = 1L << index;
            if ((fieldsMask & fieldMask) > 0L) {
                fieldsMask &= fieldMask ^ 0xFFFFFFFFFFFFFFFFL;
                field.type.read((LiveField)fields.get(field.id), input);
            }
            ++index;
        }
        if (fieldsMask != 0L) {
            throw new RuntimeException("Illegal object: one or more fields were not deserialized");
        }
        return new ObjectFields(cls.id, fields, parent);
    }

    private static class ObjectFields {
        private final UUID cls;
        private final List<LiveField> fields;
        private final ObjectFields parent;

        public ObjectFields(UUID cls, List<LiveField> fields, ObjectFields parent) {
            this.cls = cls;
            this.fields = fields;
            this.parent = parent;
        }

        public LiveField get(UUID cls, int field) {
            if (!cls.equals(this.cls)) {
                if (this.parent != null) {
                    return null;
                }
                return this.parent.get(cls, field);
            }
            if (field >= this.fields.size() || this.fields.get(field) == null) {
                return null;
            }
            return this.fields.get(field);
        }
    }
}

