/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.entitysyncer.structured;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.openzen.entitysyncer.structured.BaseStructuredObject;
import org.openzen.entitysyncer.structured.GenericStructuredObject;
import org.openzen.entitysyncer.structured.StructuredClassFactory;
import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.structured.definition.StructFieldType;
import org.openzen.entitysyncer.structured.definition.StructuredObjectClass;

public class StructuredClassRegistry {
    private final Map<UUID, StructuredClassEntry<?>> entriesByUUID = new HashMap();
    private final Map<Class<?>, StructuredClassEntry<?>> entriesByClass = new HashMap();
    private final Map<UUID, StructFieldType<?>> structTypes = new HashMap();

    public <T extends StructuredObject> void register(Class<T> cls, StructuredObjectClass objectClass, StructuredClassFactory<T> factory) {
        StructuredClassEntry<?> superclassEntry;
        if (objectClass.superclass != null && (superclassEntry = this.entriesByUUID.get(objectClass.superclass.id)) == null) {
            throw new IllegalArgumentException("Superclass is not yet registered! Make sure to register the superclass first.");
        }
        StructuredClassEntry entry = new StructuredClassEntry(objectClass.id, cls, factory, objectClass);
        this.entriesByUUID.put(objectClass.id, entry);
        this.entriesByClass.put(cls, entry);
    }

    public void register(StructuredObjectClass objectClass) {
        StructuredClassEntry<?> superclassEntry = null;
        if (objectClass.superclass != null && (superclassEntry = this.entriesByUUID.get(objectClass.superclass.id)) == null) {
            throw new IllegalArgumentException("Superclass is not yet registered! Make sure to register the superclass first.");
        }
        StructuredClassEntry entry = new StructuredClassEntry(objectClass.id, null, new GenericFactory(superclassEntry, objectClass), objectClass);
        this.entriesByUUID.put(objectClass.id, entry);
    }

    public void register(StructFieldType<?> type) {
        this.structTypes.put(type.id, type);
    }

    public boolean knows(UUID uuid) {
        return !this.entriesByUUID.containsKey(uuid);
    }

    public StructuredObject read(UUID clsid, StructuredDataInputStream input) {
        return this.entriesByUUID.get((Object)clsid).factory.read(input);
    }

    public StructFieldType<?> getStructType(UUID id) {
        return this.structTypes.get(id);
    }

    public StructuredObjectClass getStructuredClass(UUID id) {
        return this.entriesByUUID.get((Object)id).structuredClass;
    }

    private class GenericFactory
    implements StructuredClassFactory<BaseStructuredObject> {
        private final StructuredClassEntry<?> superEntry;
        private final StructuredObjectClass definition;

        public GenericFactory(StructuredClassEntry<?> superEntry, StructuredObjectClass definition) {
            this.superEntry = superEntry;
            this.definition = definition;
        }

        @Override
        public BaseStructuredObject read(StructuredDataInputStream input) {
            return new GenericStructuredObject(this.definition, input);
        }
    }

    private class StructuredClassEntry<T extends StructuredObject> {
        public final UUID id;
        public final Class<T> cls;
        public final StructuredClassFactory<T> factory;
        public final StructuredObjectClass structuredClass;

        private StructuredClassEntry(UUID id, Class<T> cls, StructuredClassFactory<T> factory, StructuredObjectClass structuredClass) {
            this.id = id;
            this.cls = cls;
            this.factory = factory;
            this.structuredClass = structuredClass;
        }
    }
}

