/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.datasets.stored;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.openzen.entitysyncer.datasets.Dataset;
import org.openzen.entitysyncer.datasets.DatasetProvider;
import org.openzen.packetstreams.crypto.CryptoPublicKey;

/**
 *
 * @author Hoofdgebruiker
 */
public class StoredDatasetProvider implements DatasetProvider {
	private final File directory;
	private final String type;
	private final Map<Long, StoredDataset> loadedDatasetsByID = new HashMap<>();
	private final Map<UUID, StoredDataset> loadedDatasetsByUUID = new HashMap<>();
	private final DeltaDatasetProvider provider;
	
	public StoredDatasetProvider(File directory, String type, DeltaDatasetProvider provider) {
		this.directory = directory;
		this.type = type;
		this.provider = provider;
	}

	@Override
	public String getType() {
		return type;
	}

	@Override
	public Dataset getById(CryptoPublicKey clientPublicKey, long id) {
		synchronized (loadedDatasetsByID) {
			if (loadedDatasetsByID.containsKey(id))
				return loadedDatasetsByID.get(id);
			
			DeltaDataset deltaDataset = provider.getById(id);
			if (deltaDataset == null)
				return null;
			
			try {
				File file = new File(directory, Long.toString(id));
				StoredDataset dataset = new StoredDataset(file, deltaDataset);
				loadedDatasetsByID.put(id, dataset);
				return dataset;
			} catch (IOException ex) {
				throw new RuntimeException("Cannot load dataset", ex);
			}
		}
	}

	@Override
	public Dataset getByUUID(CryptoPublicKey clientPublicKey, UUID uuid) {
		synchronized (loadedDatasetsByUUID) {
			if (loadedDatasetsByUUID.containsKey(uuid))
				return loadedDatasetsByUUID.get(uuid);
			
			DeltaDataset deltaDataset = provider.getByUUID(uuid);
			if (deltaDataset == null)
				return null;
			
			try {
				File file = new File(directory, uuid.toString());
				StoredDataset dataset = new StoredDataset(file, deltaDataset);
				loadedDatasetsByUUID.put(uuid, dataset);
				return dataset;
			} catch (IOException ex) {
				throw new RuntimeException("Cannot load dataset", ex);
			}
		}
	}
}
