/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.live;

/**
 *
 * @author Hoofdgebruiker
 */
public class Subscribable {
	public static final int PRIORITY_HIGH = 100;
    public static final int PRIORITY_DEFAULT = 0;
    public static final int PRIORITY_LOW = -100;
	
	// implements a linked list of nodes
	private volatile EventListenerNode firstListener = null;
	private EventListenerNode lastListener = null;

	/**
	 * Adds an IEventListener to the list.
	 *
	 * @param listener event listener
	 * @return event listener's handle
	 */
	public LiveSubscription subscribe(LiveListener listener)
	{
        return subscribe(listener, PRIORITY_DEFAULT);
    }

    public LiveSubscription subscribe(LiveListener listener, int priority)
	{
		EventListenerNode node = new EventListenerNode(listener, priority);
		
		synchronized (this) {
			if (firstListener == null) {
				firstListener = lastListener = node;
			} else {
                // prioritized list: where to insert?
                EventListenerNode previousNode = lastListener;
                while (previousNode != null && priority > previousNode.priority) {
                    previousNode = previousNode.prev;
                }

                if (previousNode == null) {
                    node.next = firstListener;
                    firstListener.prev = previousNode;
                    firstListener = node;
                } else {
                    if (previousNode.next == null) {
                        lastListener = node;
                    } else {
                        previousNode.next.prev = node;
                    }

                    previousNode.next = node;
                    node.prev = previousNode;
                }
            }
		}

		return node;
	}
	
	protected void publish()
	{
		EventListenerNode current = firstListener;
		
		while (current != null) {
			current.listener.onChanged();
			current = current.next;
		}
	}

	// =======================
	// === Private classes ===
	// =======================

	protected class EventListenerNode implements LiveSubscription
	{
		protected final LiveListener listener;
        protected final int priority;
		protected EventListenerNode next = null;
		protected EventListenerNode prev = null;

		public EventListenerNode(LiveListener listener, int priority)
		{
			this.listener = listener;
            this.priority = priority;
		}

		@Override
		public void close()
		{
			synchronized (Subscribable.this) {
				if (prev == null) {
					firstListener = next;
				} else {
					prev.next = next;
				}

				if (next == null) {
					lastListener = prev;
				} else {
					next.prev = prev;
				}
			}
		}
	}
}
