/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.openzen.entitysyncer.live.field.LiveField;
import org.openzen.entitysyncer.structured.definition.StructuredFieldDefinition;
import org.openzen.entitysyncer.structured.definition.StructuredObjectClass;

/**
 *
 * @author Hoofdgebruiker
 */
public abstract class BaseStructuredObject implements StructuredObject {
	private final UUID id;
	private ObjectFields fields = null;
	
	public BaseStructuredObject(UUID id) {
		this.id = id;
	}
	
	protected final void initNew() {
		fields = create(getStructuredClass());
	}
	
	protected final void initFrom(StructuredDataInputStream input) {
		fields = read(getStructuredClass(), input);
	}
	
	@Override
	public UUID getId() {
		return id;
	}
	
	@Override
	public LiveField getField(UUID clsid, int index) {
		return fields.get(clsid, index);
	}
	
	private ObjectFields create(StructuredObjectClass cls) {
		ObjectFields parent = null;
		if (cls.superclass != null) {
			parent = create(cls.superclass);
		}
		
		List<LiveField> fields = new ArrayList<>();
		for (StructuredFieldDefinition field : cls.getFields()) {
			while (field.id <= fields.size())
				fields.add(null);
			
			LiveField liveField = getField(cls.id, field.id);
			fields.set(field.id, liveField == null ? field.type.create() : liveField);
		}
		
		return new ObjectFields(cls.id, fields, parent);
	}
	
	private ObjectFields read(StructuredObjectClass cls, StructuredDataInputStream input) {
		ObjectFields parent = null;
		if (cls.superclass != null) {
			parent = read(cls.superclass, input);
		}
		
		List<LiveField> fields = new ArrayList<>();
		for (StructuredFieldDefinition field : cls.getFields()) {
			while (field.id <= fields.size())
				fields.add(null);
			
			LiveField liveField = getField(cls.id, field.id);
			fields.set(field.id, liveField == null ? field.type.create() : liveField);
		}
		
		long fieldsMask = input.input.readVarULong();
		int index = 0;
		for (StructuredFieldDefinition field : cls.getFields()) {
			long fieldMask = 1L << index;
			if ((fieldsMask & fieldMask) > 0) {
				fieldsMask &= ~fieldMask;
				field.type.read(fields.get(field.id), input);
			}
			
			index++;
		}
		
		if (fieldsMask != 0) {
			throw new RuntimeException("Illegal object: one or more fields were not deserialized");
		}
		
		return new ObjectFields(cls.id, fields, parent);
	}
	
	private static class ObjectFields {
		private final UUID cls;
		private final List<LiveField> fields;
		private final ObjectFields parent;
		
		public ObjectFields(UUID cls, List<LiveField> fields, ObjectFields parent) {
			this.cls = cls;
			this.fields = fields;
			this.parent = parent;
		}
		
		public LiveField get(UUID cls, int field) {
			if (!cls.equals(this.cls)) {
				if (parent != null)
					return null;
				
				return parent.get(cls, field);
			}
			
			if (field >= fields.size() || fields.get(field) == null)
				return null;
			
			return fields.get(field);
		}
	}
}
