/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.openzen.entitysyncer.structured.definition.StructFieldType;
import org.openzen.entitysyncer.structured.definition.StructuredObjectClass;
import org.openzen.packetstreams.io.DataInput;

/**
 *
 * @author Hoofdgebruiker
 */
public class StructuredDataInputStream {
	private final StructuredClassRegistry registry;
	private final List<UUID> classIds = new ArrayList<>();
	private final Map<UUID, Integer> classIndices = new HashMap<>();
	private final Map<UUID, StructuredObject> knownObjects;
	
	public final DataInput input;
	
	public StructuredDataInputStream(StructuredClassRegistry registry, DataInput input) {
		this(registry, input, new HashMap<>());
	}
	
	public StructuredDataInputStream(StructuredClassRegistry registry, DataInput input, Map<UUID, StructuredObject> knownObjects) {
		this.registry = registry;
		this.input = input;
		this.knownObjects = knownObjects;
		
		classIds.add(null); // 0: use class
		classIds.add(null); // 1: define ad-hoc class (also creates a reference)
	}
	
	public StructuredObject readStructuredObject() {
		UUID objectId = input.readUUID();
		if (knownObjects.containsKey(objectId))
			return knownObjects.get(objectId);
		
		UUID clsid = readClass();
		if (!registry.knows(clsid))
			throw new RuntimeException("Unknown class: " + clsid);
		
		return registry.read(clsid, objectId, this);
	}
	
	public StructFieldType<?> getStructType(UUID id) {
		StructFieldType<?> result = registry.getStructType(id);
		if (result == null)
			throw new RuntimeException("Unknown struct type: " + id);
		
		return result;
	}
	
	public StructuredObjectClass getStructuredClass(UUID id) {
		return registry.getStructuredClass(id);
	}
	
	private UUID readClass() {
		int id = input.readVarUInt();
		if (id == 0) {
			UUID uuid = input.readUUID();
			int newid = classIds.size();
			classIds.add(uuid);
			classIndices.put(uuid, newid);
			return uuid;
		} else if (id == 1) {
			StructuredObjectClass definition = new StructuredObjectClass(this);
			if (!registry.knows(definition.id))
				registry.register(definition);
			
			int newid = classIds.size();
			classIds.add(definition.id);
			classIndices.put(definition.id, newid);
			return definition.id;
		} else {
			return classIds.get(id);
		}
	}
}
