/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.openzen.entitysyncer.structured.definition.StructuredFieldDefinition;
import org.openzen.packetstreams.io.DataOutput;

/**
 *
 * @author Hoofdgebruiker
 */
public class StructuredDataOutputStream {
	private final StructuredClassRegistry registry;
	private final List<UUID> classIds = new ArrayList<>();
	private final Map<UUID, Integer> classIndices = new HashMap<>();
	private final Set<UUID> knownObjects;
	
	public final DataOutput output;
	
	public StructuredDataOutputStream(StructuredClassRegistry registry, DataOutput output) {
		this(registry, output, new HashSet<>());
	}
	
	public StructuredDataOutputStream(StructuredClassRegistry registry, DataOutput output, Set<UUID> knownObjects) {
		this.registry = registry;
		this.output = output;
		this.knownObjects = knownObjects;
		
		classIds.add(null); // 0: use class
		classIds.add(null); // 1: define ad-hoc class (also creates a reference)
	}
	
	public void write(StructuredObject object) {
		output.writeUUID(object.getId());
		if (knownObjects.contains(object.getId()))
			return;
		
		knownObjects.add(object.getId());
		
		UUID clsid = object.getStructuredClass().id;
		if (classIndices.containsKey(clsid)) {
			output.writeVarUInt(classIndices.get(clsid));
		} else if (registry.knows(clsid)) {
			int index = classIds.size();
			classIds.add(clsid);
			classIndices.put(clsid, index);
			output.writeVarUInt(0);
			output.writeUUID(clsid);
		} else {
			output.writeVarUInt(1);
			int index = classIds.size();
			classIds.add(clsid);
			classIndices.put(clsid, index);
			
			output.writeVarUInt(1);
			object.getStructuredClass().serialize(this);
		}
		
		writeContents(object);
	}
	
	private void writeContents(StructuredObject object) {
		// TODO: base class fields
		
		long fieldMask = 0;
		StructuredFieldDefinition[] fields = object.getStructuredClass().getFields();
		for (int i = 0; i < fields.length; i++) {
			if (fields[i] != null)
				fieldMask |= (1L << i);
		}
		
		output.writeVarULong(fieldMask);
		
		for (StructuredFieldDefinition field : fields) {
			if (field == null)
				continue;
			
			field.type.write(this, object.getField(object.getStructuredClass().id, field.id));
		}
	}
}
