/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.entitysyncer.server;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.openzen.entitysyncer.datasets.DatasetProvider;
import org.openzen.entitysyncer.datasets.DatasetSubscriber;
import org.openzen.entitysyncer.datasets.DatasetSubscription;
import org.openzen.packetstreams.BufferedServiceStream;
import org.openzen.packetstreams.crypto.CryptoPublicKey;
import org.openzen.packetstreams.io.BytesDataInput;
import org.openzen.packetstreams.io.BytesDataOutput;

public class EntitySyncerServerStream
extends BufferedServiceStream {
    private final List<DatasetProvider> datasetProviders;
    private final CryptoPublicKey publicKey;
    private final List<DatasetSubscription> connections = new ArrayList<DatasetSubscription>();

    public EntitySyncerServerStream(List<DatasetProvider> datasetProviders, CryptoPublicKey publicKey) {
        this.datasetProviders = datasetProviders;
        this.publicKey = publicKey;
    }

    public void writePacket(byte[] bytes) {
        BytesDataInput input = new BytesDataInput(bytes);
        switch (input.readVarUInt()) {
            case 1: {
                int providerId = input.readVarUInt();
                if (providerId >= this.datasetProviders.size()) break;
                long id = input.readVarULong();
                ServerSubscriber subscriber = new ServerSubscriber(this.connections.size());
                this.connections.add(this.datasetProviders.get(providerId).getById(this.publicKey, id).connect(subscriber));
                break;
            }
            case 2: {
                int providerId = input.readVarUInt();
                if (providerId >= this.datasetProviders.size()) break;
                UUID uuid = input.readUUID();
                ServerSubscriber subscriber = new ServerSubscriber(this.connections.size());
                this.connections.add(this.datasetProviders.get(providerId).getByUUID(this.publicKey, uuid).connect(subscriber));
                break;
            }
            case 4: {
                int providerId = input.readVarUInt();
                if (providerId >= this.datasetProviders.size()) break;
                long id = input.readVarULong();
                byte[] version = input.readByteArray();
                ServerSubscriber subscriber = new ServerSubscriber(this.connections.size());
                this.connections.add(this.datasetProviders.get(providerId).getById(this.publicKey, id).connect(version, subscriber));
                break;
            }
            case 5: {
                int providerId = input.readVarUInt();
                if (providerId >= this.datasetProviders.size()) break;
                UUID uuid = input.readUUID();
                byte[] version = input.readByteArray();
                ServerSubscriber subscriber = new ServerSubscriber(this.connections.size());
                this.connections.add(this.datasetProviders.get(providerId).getByUUID(this.publicKey, uuid).connect(subscriber));
                break;
            }
            case 6: {
                int connectionId = input.readVarUInt();
                if (connectionId >= this.connections.size() || this.connections.get(connectionId) == null) break;
                this.connections.get(connectionId).close();
                break;
            }
        }
    }

    public void onClosed() {
        for (DatasetSubscription connection : this.connections) {
            if (connection == null) continue;
            connection.close();
        }
    }

    private class ServerSubscriber
    implements DatasetSubscriber {
        public final int id;

        public ServerSubscriber(int id) {
            this.id = id;
        }

        @Override
        public void onNewState(byte[] version, byte[] state) {
            BytesDataOutput output = new BytesDataOutput();
            output.writeVarUInt(1);
            output.writeVarUInt(this.id);
            output.writeByteArray(version);
            output.writeByteArray(state);
            EntitySyncerServerStream.this.send(output.toByteArray());
        }

        @Override
        public void onUpdated(byte[] version, byte[] update) {
            BytesDataOutput output = new BytesDataOutput();
            output.writeVarUInt(2);
            output.writeVarUInt(this.id);
            output.writeByteArray(version);
            output.writeByteArray(update);
            EntitySyncerServerStream.this.send(output.toByteArray());
        }
    }
}

