/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.entitysyncer.structured;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.openzen.entitysyncer.structured.StructuredClassRegistry;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.structured.definition.StructuredFieldDefinition;
import org.openzen.packetstreams.io.DataOutput;

public class StructuredDataOutputStream {
    private final StructuredClassRegistry registry;
    private final List<UUID> classIds = new ArrayList<UUID>();
    private final Map<UUID, Integer> classIndices = new HashMap<UUID, Integer>();
    private final Set<UUID> knownObjects;
    public final DataOutput output;

    public StructuredDataOutputStream(StructuredClassRegistry registry, DataOutput output) {
        this(registry, output, new HashSet<UUID>());
    }

    public StructuredDataOutputStream(StructuredClassRegistry registry, DataOutput output, Set<UUID> knownObjects) {
        this.registry = registry;
        this.output = output;
        this.knownObjects = knownObjects;
        this.classIds.add(null);
        this.classIds.add(null);
    }

    public void write(StructuredObject object) {
        this.output.writeUUID(object.getId());
        if (this.knownObjects.contains(object.getId())) {
            return;
        }
        this.knownObjects.add(object.getId());
        UUID clsid = object.getStructuredClass().id;
        if (this.classIndices.containsKey(clsid)) {
            this.output.writeVarUInt(this.classIndices.get(clsid).intValue());
        } else if (this.registry.knows(clsid)) {
            int index = this.classIds.size();
            this.classIds.add(clsid);
            this.classIndices.put(clsid, index);
            this.output.writeVarUInt(0);
            this.output.writeUUID(clsid);
        } else {
            this.output.writeVarUInt(1);
            int index = this.classIds.size();
            this.classIds.add(clsid);
            this.classIndices.put(clsid, index);
            this.output.writeVarUInt(1);
            object.getStructuredClass().serialize(this);
        }
        this.writeContents(object);
    }

    private void writeContents(StructuredObject object) {
        long fieldMask = 0L;
        StructuredFieldDefinition[] fields = object.getStructuredClass().getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i] == null) continue;
            fieldMask |= 1L << i;
        }
        this.output.writeVarULong(fieldMask);
        for (StructuredFieldDefinition field : fields) {
            if (field == null) continue;
            field.type.write(this, object.getField(object.getStructuredClass().id, field.id));
        }
    }
}

