/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.live.field;

import org.openzen.entitysyncer.live.LiveInt;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.structured.definition.IntFieldType;
import org.openzen.entitysyncer.structured.definition.StructuredFieldType;

/**
 *
 * @author Hoofdgebruiker
 */
public class LiveIntField extends LiveBaseNumberField implements LiveInt {
	private int value;
	
	public LiveIntField() {
		value = 0;
	}
	
	public LiveIntField(int value) {
		this.value = value;
	}
	
	@Override
	public int get() {
		return value;
	}
	
	public void set(int value) {
		this.value = value;
		publish();
	}
	
	@Override
	public void clear() {
		set(0);
	}
	
	@Override
	public StructuredFieldType getType() {
		return IntFieldType.INSTANCE;
	}

	@Override
	public boolean asBoolValue() {
		return value != 0;
	}

	@Override
	public LiveInt asInt() {
		return this;
	}

	@Override
	public int asIntValue() {
		return value;
	}

	@Override
	public long asLongValue() {
		return value;
	}

	@Override
	public float asFloatValue() {
		return value;
	}

	@Override
	public double asDoubleValue() {
		return value;
	}

	@Override
	public String asStringValue() {
		return Integer.toString(value);
	}

	@Override
	public StructuredObject asObjectValue() {
		throw new ClassCastException("Cannot cast int to an object");
	}
}
