/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.definition;

import org.openzen.entitysyncer.live.any.LiveAny;
import org.openzen.entitysyncer.live.field.LiveDoubleField;
import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.structured.StructuredDataOutputStream;
import org.openzen.entitysyncer.live.field.LiveField;

/**
 *
 * @author Hoofdgebruiker
 */
public class DoubleFieldType implements StructuredFieldType {
	public static final DoubleFieldType INSTANCE = new DoubleFieldType();
	
	private DoubleFieldType() {}

	@Override
	public LiveField create() {
		return new LiveDoubleField();
	}

	@Override
	public void serialize(StructuredDataOutputStream output) {
		output.output.writeVarUInt(TYPE_DOUBLE);
	}

	@Override
	public void read(LiveField field, StructuredDataInputStream input) {
		field.asDouble().set(input.input.readDouble());
	}

	@Override
	public void write(StructuredDataOutputStream output, LiveAny value) {
		output.output.writeDouble(value.asDoubleValue());
	}
}
