/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.definition;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.structured.StructuredDataOutputStream;

/**
 *
 * @author Hoofdgebruiker
 */
public class StructuredObjectClass {
	private static final UUID NO_SUPERCLASS = new UUID(0, 0);
	
	public final UUID id;
	public final StructuredObjectClass superclass;
	
	private final StructuredFieldDefinition[] fields;
	private final Map<Integer, StructuredFieldDefinition> fieldsById = new HashMap<>();
	
	public StructuredObjectClass(UUID id, StructuredObjectClass superclass, StructuredFieldDefinition... fields) {
		this.id = id;
		this.superclass = superclass;
		this.fields = fields;
		
		for (StructuredFieldDefinition field : fields)
			fieldsById.put(field.id, field);
	}
	
	public StructuredObjectClass(StructuredDataInputStream input) {
		id = input.input.readUUID();
		UUID superclassId = input.input.readUUID();
		superclass = superclassId.equals(NO_SUPERCLASS) ? null : input.getStructuredClass(superclassId);
		
		int numFields = input.input.readVarUInt();
		fields = new StructuredFieldDefinition[numFields];
		for (int i = 0; i < fields.length; i++) {
			fields[i] = new StructuredFieldDefinition(input);
		
		for (StructuredFieldDefinition field : fields)
			fieldsById.put(field.id, field);
		}
	}
	
	public StructuredFieldDefinition[] getFields() {
		return fields;
	}
	
	public StructuredFieldDefinition getField(int index) {
		return fieldsById.get(index);
	}
	
	public void serialize(StructuredDataOutputStream output) {
		output.output.writeUUID(id);
		output.output.writeUUID(superclass == null ? NO_SUPERCLASS : superclass.id);
		output.output.writeVarUInt(fields.length);
		
		for (StructuredFieldDefinition field : fields) {
			field.serialize(output);
		}
	}
}
