/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.live.field;

import org.openzen.entitysyncer.live.LiveBool;
import org.openzen.entitysyncer.live.LiveBoolFunction;
import org.openzen.entitysyncer.live.LiveDouble;
import org.openzen.entitysyncer.live.LiveDoubleFunction;
import org.openzen.entitysyncer.live.LiveFloat;
import org.openzen.entitysyncer.live.LiveFloatFunction;
import org.openzen.entitysyncer.live.LiveInt;
import org.openzen.entitysyncer.live.LiveIntFunction;
import org.openzen.entitysyncer.live.LiveLong;
import org.openzen.entitysyncer.live.LiveLongFunction;
import org.openzen.entitysyncer.live.LiveObject;
import org.openzen.entitysyncer.live.LiveString;
import org.openzen.entitysyncer.live.Subscribable;
import org.openzen.entitysyncer.structured.StructuredObject;

/**
 *
 * @author Hoofdgebruiker
 */
public class LiveStringField extends LiveBaseField implements LiveString {
	private String value;
	
	public LiveStringField(String value) {
		this.value = value;
	}
	
	@Override
	public String get() {
		return value;
	}
	
	public void set(String value) {
		this.value = value;
		publish();
	}
	
	@Override
	public boolean asBoolValue() {
		return Boolean.parseBoolean(value);
	}
	
	@Override
	public int asIntValue() {
		return Integer.parseInt(value);
	}
	
	@Override
	public long asLongValue() {
		return Long.parseLong(value);
	}

	@Override
	public float asFloatValue() {
		return Float.parseFloat(value);
	}
	
	@Override
	public double asDoubleValue() {
		return Double.parseDouble(value);
	}

	@Override
	public LiveString asString() {
		return this;
	}
	
	@Override
	public String asStringValue() {
		return value;
	}

	@Override
	public LiveObject<?> asObject() {
		throw new ClassCastException("Cannot convert a string to an object");
	}
	
	@Override
	public StructuredObject asObjectValue() {
		throw new ClassCastException("Cannot convert a string to an object");
	}

	@Override
	public void setBool(boolean value) {
		set(Boolean.toString(value));
	}

	@Override
	public void setInt(int value) {
		set(Integer.toString(value));
	}

	@Override
	public void setLong(long value) {
		set(Long.toString(value));
	}

	@Override
	public void setFloat(float value) {
		set(Float.toString(value));
	}

	@Override
	public void setDouble(double value) {
		set(Double.toString(value));
	}

	@Override
	public void setString(String value) {
		set(value);
	}

	@Override
	public void setObject(StructuredObject value) {
		throw new ClassCastException("Cannot convert an object to a string");
	}
}
