/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.commit;

import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.live.field.LiveField;

/**
 *
 * @author Hoofdgebruiker
 */
public class SetLongFieldOperation extends StructuredSetOperation {
	private final long value;
	
	public SetLongFieldOperation(int object, int field, long value) {
		super(object, field);
		
		this.value = value;
	}
	
	public SetLongFieldOperation(StructuredDataInputStream input) {
		super(input);
		
		this.value = input.input.readVarLong();
	}

	@Override
	protected void apply(LiveField field) {
		field.setLong(value);
	}
}
