/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.definition;

import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.packetstreams.io.DataInput;
import org.openzen.packetstreams.io.DataOutput;
import org.openzen.entitysyncer.live.field.LiveField;

/**
 *
 * @author Hoofdgebruiker
 */
public class StructuredFieldDefinition {
	public final int id;
	public final String name;
	public final StructuredFieldType type;
	
	public StructuredFieldDefinition(int id, String name, StructuredFieldType type) {
		this.id = id;
		this.name = name;
		this.type = type;
	}
	
	public StructuredFieldDefinition(DataInput input) {
		id = input.readVarUInt();
		name = input.readString();
		type = readType(input);
	}
	
	public void read(LiveField field, StructuredDataInputStream input) {
		type.read(field, input);
	}
	
	private static StructuredFieldType readType(DataInput input) {
		int type = input.readVarUInt();
		switch (type) {
			case StructuredFieldType.TYPE_BOOL:
				return BoolFieldType.INSTANCE;
			case StructuredFieldType.TYPE_INT:
				return IntFieldType.INSTANCE;
			case StructuredFieldType.TYPE_LONG:
				return LongFieldType.INSTANCE;
			case StructuredFieldType.TYPE_FLOAT:
				return FloatFieldType.INSTANCE;
			case StructuredFieldType.TYPE_DOUBLE:
				return DoubleFieldType.INSTANCE;
			case StructuredFieldType.TYPE_STRING:
				return StringFieldType.INSTANCE;
			case StructuredFieldType.TYPE_OBJECT:
				return new ObjectFieldType(input.readUUID());
			default:
				throw new RuntimeException("Invalid field type: " + type);
		}
	}
	
	public void serialize(DataOutput output) {
		output.writeVarUInt(id);
		output.writeString(name);
		type.serialize(output);
	}
}
