/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.fields;

import org.openzen.entitysyncer.structured.StructuredDataOutputStream;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.packetstreams.io.DataOutput;
import org.openzen.entitysyncer.structured.StructuredField;

/**
 *
 * @author Hoofdgebruiker
 */
public class StructuredStringField implements StructuredField {
	public final String value;
	
	public StructuredStringField(String value) {
		this.value = value;
	}

	@Override
	public boolean getBool() {
		return Boolean.parseBoolean(value);
	}

	@Override
	public int getInt() {
		return Integer.parseInt(value);
	}

	@Override
	public long getLong() {
		return Long.parseLong(value);
	}

	@Override
	public float getFloat() {
		return Float.parseFloat(value);
	}

	@Override
	public double getDouble() {
		return Double.parseDouble(value);
	}

	@Override
	public String getString() {
		return value;
	}

	@Override
	public StructuredObject getObject() {
		throw new ClassCastException("Cannot cast string to object");
	}

	@Override
	public void serialize(StructuredDataOutputStream scope, DataOutput output) {
		output.writeString(value);
	}
}
