/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.entitysyncer.live.field;

import org.openzen.entitysyncer.live.LiveFloat;
import org.openzen.entitysyncer.live.field.LiveBaseField;
import org.openzen.entitysyncer.structured.StructuredObject;

public class LiveFloatField
extends LiveBaseField
implements LiveFloat {
    private float value;

    public LiveFloatField(float value) {
        this.value = value;
    }

    @Override
    public float get() {
        return this.value;
    }

    public void set(float value) {
        this.value = value;
        this.publish();
    }

    @Override
    public boolean asBoolValue() {
        return this.value != 0.0f;
    }

    @Override
    public int asIntValue() {
        return (int)this.value;
    }

    @Override
    public long asLongValue() {
        return (long)this.value;
    }

    @Override
    public LiveFloat asFloat() {
        return this;
    }

    @Override
    public float asFloatValue() {
        return this.value;
    }

    @Override
    public double asDoubleValue() {
        return this.value;
    }

    @Override
    public String asStringValue() {
        return Float.toString(this.value);
    }

    @Override
    public StructuredObject asObjectValue() {
        throw new ClassCastException("Cannot cast int to an object");
    }

    @Override
    public void setBool(boolean value) {
        this.set(value ? 1.0f : 0.0f);
    }

    @Override
    public void setInt(int value) {
        this.set(value);
    }

    @Override
    public void setLong(long value) {
        this.set(value);
    }

    @Override
    public void setFloat(float value) {
        this.set(value);
    }

    @Override
    public void setDouble(double value) {
        this.set((float)value);
    }

    @Override
    public void setString(String value) {
        this.set(Float.parseFloat(value));
    }

    @Override
    public void setObject(StructuredObject value) {
        throw new ClassCastException("Cannot cast object to float");
    }
}

