/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.entitysyncer.structured;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.openzen.entitysyncer.structured.StructuredClassFactory;
import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.structured.StructuredGenericObject;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.structured.definition.StructuredObjectClass;

public class StructuredClassRegistry {
    private final Map<UUID, StructuredClassEntry<?>> entriesByUUID = new HashMap();
    private final Map<Class<?>, StructuredClassEntry<?>> entriesByClass = new HashMap();

    public <T extends StructuredObject> void register(Class<T> cls, StructuredObjectClass objectClass, StructuredClassFactory<T> factory) {
        if (objectClass.superclassId != null) {
            StructuredClassEntry<?> superclassEntry = this.entriesByUUID.get(objectClass.superclassId);
            if (superclassEntry == null) {
                throw new IllegalArgumentException("Superclass is not yet registered! Make sure to register the superclass first.");
            }
            if (superclassEntry.cls == null || !superclassEntry.cls.isAssignableFrom(cls)) {
                throw new IllegalArgumentException("Superclass doesn't match! Class registered as superclass is not a superclass of the given class.");
            }
        }
        StructuredClassEntry entry = new StructuredClassEntry(objectClass.id, objectClass.superclassId, cls, factory);
        this.entriesByUUID.put(objectClass.id, entry);
        this.entriesByClass.put(cls, entry);
    }

    public void register(StructuredObjectClass objectClass) {
        StructuredClassEntry<?> superclassEntry = null;
        if (objectClass.superclassId != null && (superclassEntry = this.entriesByUUID.get(objectClass.superclassId)) == null) {
            throw new IllegalArgumentException("Superclass is not yet registered! Make sure to register the superclass first.");
        }
        StructuredClassEntry entry = new StructuredClassEntry(objectClass.id, objectClass.superclassId, null, new GenericFactory(superclassEntry, objectClass));
        this.entriesByUUID.put(objectClass.id, entry);
    }

    public boolean knows(UUID uuid) {
        return !this.entriesByUUID.containsKey(uuid);
    }

    public StructuredObject read(UUID clsid, StructuredDataInputStream input) {
        return this.entriesByUUID.get((Object)clsid).factory.read(input);
    }

    private class GenericFactory
    implements StructuredClassFactory<StructuredGenericObject> {
        private final StructuredClassEntry<?> superEntry;
        private final StructuredObjectClass definition;

        public GenericFactory(StructuredClassEntry<?> superEntry, StructuredObjectClass definition) {
            this.superEntry = superEntry;
            this.definition = definition;
        }

        @Override
        public StructuredGenericObject read(StructuredDataInputStream input) {
            StructuredObject baseObject = this.superEntry == null ? null : (StructuredObject)this.superEntry.factory.read(input);
            return new StructuredGenericObject(baseObject, this.definition, input);
        }
    }

    private class StructuredClassEntry<T extends StructuredObject> {
        public final UUID id;
        public final UUID superclassId;
        public final Class<T> cls;
        public final StructuredClassFactory<T> factory;

        private StructuredClassEntry(UUID id, UUID superclassId, Class<T> cls, StructuredClassFactory<T> factory) {
            this.id = id;
            this.superclassId = superclassId;
            this.cls = cls;
            this.factory = factory;
        }
    }
}

