/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.live;

/**
 *
 * @author Hoofdgebruiker
 */
public class Subscribable {
	public static final int PRIORITY_HIGH = 100;
    public static final int PRIORITY_DEFAULT = 0;
    public static final int PRIORITY_LOW = -100;
	
	// implements a linked list of nodes
	protected volatile EventListenerNode first = null;
	protected EventListenerNode last = null;

	/**
	 * Adds an IEventListener to the list.
	 *
	 * @param listener event listener
	 * @return event listener's handle
	 */
	public LiveSubscription subscribe(LiveListener listener)
	{
        return subscribe(listener, PRIORITY_DEFAULT);
    }

    public LiveSubscription subscribe(LiveListener listener, int priority)
	{
		EventListenerNode node = new EventListenerNode(listener, priority);
		
		synchronized (this) {
			if (first == null) {
				first = last = node;
			} else {
                // prioritized list: where to insert?
                EventListenerNode previousNode = last;
                while (previousNode != null && priority > previousNode.priority) {
                    previousNode = previousNode.prev;
                }

                if (previousNode == null) {
                    node.next = first;
                    first.prev = previousNode;
                    first = node;
                } else {
                    if (previousNode.next == null) {
                        last = node;
                    } else {
                        previousNode.next.prev = node;
                    }

                    previousNode.next = node;
                    node.prev = previousNode;
                }
            }
		}

		return node;
	}
	
	protected void publish()
	{
		EventListenerNode current = first;
		
		while (current != null) {
			current.listener.onChanged();
			current = current.next;
		}
	}

	// =======================
	// === Private classes ===
	// =======================

	protected class EventListenerNode implements LiveSubscription
	{
		protected final LiveListener listener;
        protected final int priority;
		protected EventListenerNode next = null;
		protected EventListenerNode prev = null;

		public EventListenerNode(LiveListener listener, int priority)
		{
			this.listener = listener;
            this.priority = priority;
		}

		@Override
		public void close()
		{
			synchronized (Subscribable.this) {
				if (prev == null) {
					first = next;
				} else {
					prev.next = next;
				}

				if (next == null) {
					last = prev;
				} else {
					next.prev = prev;
				}
			}
		}
	}
}
