/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.live.field;

import org.openzen.entitysyncer.live.LiveBool;
import org.openzen.entitysyncer.live.LiveBoolFunction;
import org.openzen.entitysyncer.live.LiveDouble;
import org.openzen.entitysyncer.live.LiveDoubleFunction;
import org.openzen.entitysyncer.live.LiveFloat;
import org.openzen.entitysyncer.live.LiveFloatFunction;
import org.openzen.entitysyncer.live.LiveInt;
import org.openzen.entitysyncer.live.LiveIntFunction;
import org.openzen.entitysyncer.live.LiveLong;
import org.openzen.entitysyncer.live.LiveLongFunction;
import org.openzen.entitysyncer.live.LiveObject;
import org.openzen.entitysyncer.live.LiveString;
import org.openzen.entitysyncer.live.LiveStringFunction;
import org.openzen.entitysyncer.live.Subscribable;

/**
 *
 * @author Hoofdgebruiker
 */
public abstract class LiveBaseField extends Subscribable implements LiveField {
	
	@Override
	public LiveBool asBool() {
		return new LiveBoolFunction(this::asBoolValue, this);
	}
	
	@Override
	public LiveInt asInt() {
		return new LiveIntFunction(this::asIntValue, this);
	}
	
	@Override
	public LiveLong asLong() {
		return new LiveLongFunction(this::asLongValue, this);
	}
	
	@Override
	public LiveFloat asFloat() {
		return new LiveFloatFunction(this::asFloatValue, this);
	}
	
	@Override
	public LiveDouble asDouble() {
		return new LiveDoubleFunction(this::asDoubleValue, this);
	}
	
	@Override
	public LiveString asString() {
		return new LiveStringFunction(this::asStringValue, this);
	}
	
	@Override
	public LiveObject asObject() {
		throw new ClassCastException("Cannot cast this field to an object");
	}
}
