/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.openzen.entitysyncer.structured.definition.StructuredFieldDefinition;
import org.openzen.packetstreams.io.DataOutput;

/**
 *
 * @author Hoofdgebruiker
 */
public class StructuredDataOutputStream {
	private final StructuredClassRegistry registry;
	private final List<UUID> classIds = new ArrayList<>();
	private final Map<UUID, Integer> classIndices = new HashMap<>();
	
	public final DataOutput output;
	public final StructuredDataset dataset;
	
	public StructuredDataOutputStream(StructuredClassRegistry registry, StructuredDataset dataset, DataOutput output) {
		this.registry = registry;
		this.dataset = dataset;
		this.output = output;
		
		classIds.add(null); // 0: use class
		classIds.add(null); // 1: define ad-hoc class (also creates a reference)
	}
	
	public void write(StructuredObject object) {
		UUID clsid = object.getStructuredClass().id;
		if (classIndices.containsKey(clsid)) {
			output.writeVarUInt(classIndices.get(clsid));
		} else if (registry.knows(clsid)) {
			int index = classIds.size();
			classIds.add(clsid);
			classIndices.put(clsid, index);
			output.writeVarUInt(0);
			output.writeUUID(clsid);
		} else {
			output.writeVarUInt(1);
			int index = classIds.size();
			classIds.add(clsid);
			classIndices.put(clsid, index);
			
			output.writeVarUInt(1);
			object.getStructuredClass().serialize(output);
		}
		
		writeContents(object);
	}
	
	private void writeContents(StructuredObject object) {
		if (object.getBaseObject() != null)
			writeContents(object.getBaseObject());
		
		long fieldMask = 0;
		StructuredFieldDefinition[] fields = object.getStructuredClass().getFields();
		for (int i = 0; i < fields.length; i++) {
			if (fields[i] != null)
				fieldMask |= (1L << i);
		}
		
		output.writeVarULong(fieldMask);
		
		for (StructuredFieldDefinition field : fields) {
			if (field == null)
				continue;
			
			field.type.write(this, object.getField(field.id));
		}
	}
}
