/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.definition;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.openzen.packetstreams.io.DataInput;
import org.openzen.packetstreams.io.DataOutput;

/**
 *
 * @author Hoofdgebruiker
 */
public class StructuredObjectClass {
	private static final UUID NO_SUPERCLASS = new UUID(0, 0);
	
	public final UUID id;
	public final UUID superclassId;
	
	private final StructuredFieldDefinition[] fields;
	private final Map<Integer, StructuredFieldDefinition> fieldsById = new HashMap<>();
	
	public StructuredObjectClass(UUID id, UUID superclassId, StructuredFieldDefinition... fields) {
		this.id = id;
		this.superclassId = superclassId;
		this.fields = fields;
		
		for (StructuredFieldDefinition field : fields)
			fieldsById.put(field.id, field);
	}
	
	public StructuredObjectClass(DataInput input) {
		id = input.readUUID();
		UUID superclass = input.readUUID();
		superclassId = superclass.equals(NO_SUPERCLASS) ? null : superclass;
		
		int numFields = input.readVarUInt();
		fields = new StructuredFieldDefinition[numFields];
		for (int i = 0; i < fields.length; i++) {
			fields[i] = new StructuredFieldDefinition(input);
		
		for (StructuredFieldDefinition field : fields)
			fieldsById.put(field.id, field);
		}
	}
	
	public StructuredFieldDefinition[] getFields() {
		return fields;
	}
	
	public StructuredFieldDefinition getField(int index) {
		return fieldsById.get(index);
	}
	
	public void serialize(DataOutput output) {
		output.writeUUID(id);
		output.writeUUID(superclassId == null ? NO_SUPERCLASS : superclassId);
		output.writeVarUInt(fields.length);
		
		for (StructuredFieldDefinition field : fields) {
			field.serialize(output);
		}
	}
}
