/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.fields;

import org.openzen.entitysyncer.structured.StructuredDataOutputStream;
import org.openzen.entitysyncer.structured.StructuredField;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.packetstreams.io.DataOutput;

/**
 *
 * @author Hoofdgebruiker
 */
public class StructuredObjectField implements StructuredField {
	public final StructuredObject value;
	
	public StructuredObjectField(StructuredObject value) {
		this.value = value;
	}

	@Override
	public boolean getBool() {
		return value != null;
	}

	@Override
	public int getInt() {
		throw new ClassCastException("Cannot convert object to int");
	}

	@Override
	public long getLong() {
		throw new ClassCastException("Cannot convert object to long");
	}

	@Override
	public float getFloat() {
		throw new ClassCastException("Cannot convert object to float");
	}

	@Override
	public double getDouble() {
		throw new ClassCastException("Cannot convert object to double");
	}

	@Override
	public String getString() {
		throw new ClassCastException("Cannot convert object to string");
	}

	@Override
	public StructuredObject getObject() {
		return value;
	}

	@Override
	public void serialize(StructuredDataOutputStream scope, DataOutput output) {
		scope.write(value);
	}
}
