/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.entitysyncer.live;

import org.openzen.entitysyncer.live.LiveListener;
import org.openzen.entitysyncer.live.LiveSubscription;

public class Subscribable {
    public static final int PRIORITY_HIGH = 100;
    public static final int PRIORITY_DEFAULT = 0;
    public static final int PRIORITY_LOW = -100;
    protected volatile EventListenerNode first = null;
    protected EventListenerNode last = null;

    public LiveSubscription subscribe(LiveListener listener) {
        return this.subscribe(listener, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveSubscription subscribe(LiveListener listener, int priority) {
        EventListenerNode node = new EventListenerNode(listener, priority);
        Subscribable subscribable = this;
        synchronized (subscribable) {
            if (this.first == null) {
                this.first = this.last = node;
            } else {
                EventListenerNode previousNode = this.last;
                while (previousNode != null && priority > previousNode.priority) {
                    previousNode = previousNode.prev;
                }
                if (previousNode == null) {
                    node.next = this.first;
                    this.first.prev = previousNode;
                    this.first = node;
                } else {
                    if (previousNode.next == null) {
                        this.last = node;
                    } else {
                        previousNode.next.prev = node;
                    }
                    previousNode.next = node;
                    node.prev = previousNode;
                }
            }
        }
        return node;
    }

    protected void publish() {
        EventListenerNode current = this.first;
        while (current != null) {
            current.listener.onChanged();
            current = current.next;
        }
    }

    protected class EventListenerNode
    implements LiveSubscription {
        protected final LiveListener listener;
        protected final int priority;
        protected EventListenerNode next = null;
        protected EventListenerNode prev = null;

        public EventListenerNode(LiveListener listener, int priority) {
            this.listener = listener;
            this.priority = priority;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Subscribable subscribable = Subscribable.this;
            synchronized (subscribable) {
                if (this.prev == null) {
                    Subscribable.this.first = this.next;
                } else {
                    this.prev.next = this.next;
                }
                if (this.next == null) {
                    Subscribable.this.last = this.prev;
                } else {
                    this.next.prev = this.prev;
                }
            }
        }
    }
}

