/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.entitysyncer.structured.fields;

import org.openzen.entitysyncer.structured.StructuredDataOutputStream;
import org.openzen.entitysyncer.structured.StructuredField;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.packetstreams.io.DataOutput;

public class StructuredBoolField
implements StructuredField {
    public final boolean value;

    public StructuredBoolField(boolean value) {
        this.value = value;
    }

    @Override
    public boolean getBool() {
        return this.value;
    }

    @Override
    public int getInt() {
        return this.value ? 1 : 0;
    }

    @Override
    public long getLong() {
        return this.value ? 1L : 0L;
    }

    @Override
    public float getFloat() {
        return this.value ? 1.0f : 0.0f;
    }

    @Override
    public double getDouble() {
        return this.value ? 1.0 : 0.0;
    }

    @Override
    public String getString() {
        return Boolean.toString(this.value);
    }

    @Override
    public StructuredObject getObject() {
        throw new ClassCastException("boolean cannot be converted to an object");
    }

    @Override
    public void serialize(StructuredDataOutputStream scope, DataOutput output) {
        output.writeBoolean(this.value);
    }
}

