/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.live.field;

import org.openzen.entitysyncer.live.LiveInt;
import org.openzen.entitysyncer.live.LiveLong;
import org.openzen.entitysyncer.structured.StructuredObject;

/**
 *
 * @author Hoofdgebruiker
 */
public class LiveLongField extends LiveBaseField implements LiveLong {
	private long value;
	
	public LiveLongField(long value) {
		this.value = value;
	}
	
	@Override
	public long get() {
		return value;
	}
	
	public void set(long value) {
		this.value = value;
		publish();
	}

	@Override
	public boolean asBoolValue() {
		return value != 0;
	}
	
	@Override
	public int asIntValue() {
		return (int) value;
	}
	
	@Override
	public LiveLong asLong() {
		return this;
	}

	@Override
	public long asLongValue() {
		return value;
	}

	@Override
	public float asFloatValue() {
		return value;
	}

	@Override
	public double asDoubleValue() {
		return value;
	}

	@Override
	public String asStringValue() {
		return Long.toString(value);
	}

	@Override
	public StructuredObject asObjectValue() {
		throw new ClassCastException("Cannot cast int to an object");
	}

	@Override
	public void setBool(boolean value) {
		set(value ? 1 : 0);
	}

	@Override
	public void setInt(int value) {
		set(value);
	}

	@Override
	public void setLong(long value) {
		set(value);
	}

	@Override
	public void setFloat(float value) {
		set((long) value);
	}

	@Override
	public void setDouble(double value) {
		set((long) value);
	}

	@Override
	public void setString(String value) {
		set(Long.parseLong(value));
	}

	@Override
	public void setObject(StructuredObject value) {
		throw new ClassCastException("Cannot cast object to long");
	}
}
