/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.commit;

import java.util.ArrayList;
import java.util.List;
import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.packetstreams.io.DataInput;

/**
 *
 * @author Hoofdgebruiker
 */
public class StructuredCommit {
	public static final int OP_END = 0;
	public static final int OP_SET_FIELD_BOOL_TRUE = 16;
	public static final int OP_SET_FIELD_BOOL_FALSE = 17;
	public static final int OP_SET_FIELD_INT = 18;
	public static final int OP_SET_FIELD_LONG = 19;
	public static final int OP_SET_FIELD_FLOAT = 20;
	public static final int OP_SET_FIELD_DOUBLE = 21;
	public static final int OP_SET_FIELD_STRING = 22;
	public static final int OP_SET_FIELD_OBJECT = 23;
	
	private final List<StructuredOperation> operations;
	
	public StructuredCommit(List<StructuredOperation> operations) {
		this.operations = operations;
	}
	
	public StructuredCommit(StructuredDataInputStream input) {
		operations = new ArrayList<>();
		
		int op = input.input.readVarUInt();
		while (op != OP_END) {
			switch (op) {
				case OP_SET_FIELD_BOOL_TRUE:
					operations.add(new SetBoolFieldOperation(input, true));
					break;
				case OP_SET_FIELD_INT:
					operations.add(new SetIntFieldOperation(input));
					break;
				case OP_SET_FIELD_LONG:
					operations.add(new SetLongFieldOperation(input));
					break;
				case OP_SET_FIELD_FLOAT:
					operations.add(new SetFloatFieldOperation(input));
					break;
				case OP_SET_FIELD_DOUBLE:
					operations.add(new SetDoubleFieldOperation(input));
					break;
				case OP_SET_FIELD_STRING:
					operations.add(new SetStringFieldOperation(input));
					break;
				case OP_SET_FIELD_OBJECT:
					operations.add(new SetObjectFieldOperation(input));
					break;
				default:
					throw new RuntimeException("Unknown operation: " + op);
			}
		
			op = input.input.readVarUInt();
		}
	}
}
