/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.definition;

import org.openzen.entitysyncer.live.any.LiveAny;
import org.openzen.entitysyncer.live.field.LiveField;
import org.openzen.entitysyncer.live.field.LiveLongField;
import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.structured.StructuredDataOutputStream;
import org.openzen.packetstreams.io.DataOutput;

/**
 *
 * @author Hoofdgebruiker
 */
public class LongFieldType implements StructuredFieldType {
	public static final LongFieldType INSTANCE = new LongFieldType();
	
	private LongFieldType() {}

	@Override
	public LiveField create() {
		return new LiveLongField(0);
	}

	@Override
	public void serialize(DataOutput output) {
		output.writeVarUInt(TYPE_LONG);
	}

	@Override
	public void read(LiveField field, StructuredDataInputStream input) {
		field.setLong(input.input.readVarLong());
	}

	@Override
	public void write(StructuredDataOutputStream output, LiveAny value) {
		output.output.writeVarLong(value.asLongValue());
	}
}
