/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.definition;

import java.util.UUID;
import org.openzen.entitysyncer.live.any.LiveAny;
import org.openzen.entitysyncer.live.field.LiveField;
import org.openzen.entitysyncer.live.field.LiveObjectField;
import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.structured.StructuredDataOutputStream;
import org.openzen.packetstreams.io.DataOutput;

/**
 *
 * @author Hoofdgebruiker
 */
public class ObjectFieldType implements StructuredFieldType {
	public final UUID clsid;
	
	public ObjectFieldType(UUID clsid) {
		this.clsid = clsid;
	}

	@Override
	public LiveField create() {
		return new LiveObjectField(null);
	}

	@Override
	public void serialize(DataOutput output) {
		output.writeVarUInt(TYPE_OBJECT);
		output.writeUUID(clsid);
	}

	@Override
	public void read(LiveField field, StructuredDataInputStream input) {
		field.setObject(input.readStructuredObject());
	}

	@Override
	public void write(StructuredDataOutputStream output, LiveAny value) {
		output.write(value.asObjectValue());
	}
}
