/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.fields;

import org.openzen.entitysyncer.structured.StructuredDataOutputStream;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.packetstreams.io.DataOutput;
import org.openzen.entitysyncer.structured.StructuredField;

/**
 *
 * @author Hoofdgebruiker
 */
public class StructuredBoolField implements StructuredField {
	public final boolean value;
	
	public StructuredBoolField(boolean value) {
		this.value = value;
	}
	
	@Override
	public boolean getBool() {
		return value;
	}

	@Override
	public int getInt() {
		return value ? 1 : 0;
	}

	@Override
	public long getLong() {
		return value ? 1 : 0;
	}

	@Override
	public float getFloat() {
		return value ? 1 : 0;
	}

	@Override
	public double getDouble() {
		return value ? 1 : 0;
	}

	@Override
	public String getString() {
		return Boolean.toString(value);
	}

	@Override
	public StructuredObject getObject() {
		throw new ClassCastException("boolean cannot be converted to an object");
	}

	@Override
	public void serialize(StructuredDataOutputStream scope, DataOutput output) {
		output.writeBoolean(value);
	}
}
