/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.fields;

import org.openzen.entitysyncer.structured.StructuredDataOutputStream;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.packetstreams.io.DataOutput;
import org.openzen.entitysyncer.structured.StructuredField;

/**
 *
 * @author Hoofdgebruiker
 */
public class StructuredFloatField implements StructuredField {
	private final float value;
	
	public StructuredFloatField(float value) {
		this.value = value;
	}

	@Override
	public boolean getBool() {
		throw new ClassCastException("Cannot convert float to bool");
	}

	@Override
	public int getInt() {
		return (int) value;
	}

	@Override
	public long getLong() {
		return (long) value;
	}

	@Override
	public float getFloat() {
		return value;
	}

	@Override
	public double getDouble() {
		return value;
	}

	@Override
	public String getString() {
		return Float.toString(value);
	}

	@Override
	public StructuredObject getObject() {
		throw new ClassCastException("Cannot convert float to object");
	}

	@Override
	public void serialize(StructuredDataOutputStream scope, DataOutput output) {
		output.writeFloat(value);
	}
}
