/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.fields;

import org.openzen.entitysyncer.structured.StructuredDataOutputStream;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.packetstreams.io.DataOutput;
import org.openzen.entitysyncer.structured.StructuredField;

/**
 *
 * @author Hoofdgebruiker
 */
public class StructuredLongField implements StructuredField {
	public final long value;
	
	public StructuredLongField(long value) {
		this.value = value;
	}
	
	@Override
	public boolean getBool() {
		return value != 0;
	}

	@Override
	public int getInt() {
		return (int) value;
	}

	@Override
	public long getLong() {
		return value;
	}

	@Override
	public float getFloat() {
		return value;
	}

	@Override
	public double getDouble() {
		return value;
	}

	@Override
	public String getString() {
		return Long.toString(value);
	}

	@Override
	public StructuredObject getObject() {
		throw new ClassCastException("Cannot convert long to a structured object");
	}

	@Override
	public void serialize(StructuredDataOutputStream scope, DataOutput output) {
		output.writeVarLong(value);
	}
}
