/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.entitysyncer.live.field;

import org.openzen.entitysyncer.live.LiveDouble;
import org.openzen.entitysyncer.live.field.LiveBaseField;
import org.openzen.entitysyncer.structured.StructuredObject;

public class LiveDoubleField
extends LiveBaseField
implements LiveDouble {
    private double value;

    public LiveDoubleField(double value) {
        this.value = value;
    }

    @Override
    public double get() {
        return this.value;
    }

    public void set(double value) {
        this.value = value;
        this.publish();
    }

    @Override
    public boolean asBoolValue() {
        return this.value != 0.0;
    }

    @Override
    public int asIntValue() {
        return (int)this.value;
    }

    @Override
    public long asLongValue() {
        return (long)this.value;
    }

    @Override
    public float asFloatValue() {
        return (float)this.value;
    }

    @Override
    public LiveDouble asDouble() {
        return this;
    }

    @Override
    public double asDoubleValue() {
        return this.value;
    }

    @Override
    public String asStringValue() {
        return Double.toString(this.value);
    }

    @Override
    public StructuredObject asObjectValue() {
        throw new ClassCastException("Cannot cast double to an object");
    }

    @Override
    public void setBool(boolean value) {
        this.set(value ? 1.0 : 0.0);
    }

    @Override
    public void setInt(int value) {
        this.set(value);
    }

    @Override
    public void setLong(long value) {
        this.set(value);
    }

    @Override
    public void setFloat(float value) {
        this.set(value);
    }

    @Override
    public void setDouble(double value) {
        this.set(value);
    }

    @Override
    public void setString(String value) {
        this.set(Double.parseDouble(value));
    }

    @Override
    public void setObject(StructuredObject value) {
        throw new ClassCastException("Cannot cast object to double");
    }
}

