/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.entitysyncer.live.field;

import org.openzen.entitysyncer.live.LiveObject;
import org.openzen.entitysyncer.live.LiveString;
import org.openzen.entitysyncer.live.field.LiveBaseField;
import org.openzen.entitysyncer.structured.StructuredObject;

public class LiveStringField
extends LiveBaseField
implements LiveString {
    private String value;

    public LiveStringField(String value) {
        this.value = value;
    }

    @Override
    public String get() {
        return this.value;
    }

    public void set(String value) {
        this.value = value;
        this.publish();
    }

    @Override
    public boolean asBoolValue() {
        return Boolean.parseBoolean(this.value);
    }

    @Override
    public int asIntValue() {
        return Integer.parseInt(this.value);
    }

    @Override
    public long asLongValue() {
        return Long.parseLong(this.value);
    }

    @Override
    public float asFloatValue() {
        return Float.parseFloat(this.value);
    }

    @Override
    public double asDoubleValue() {
        return Double.parseDouble(this.value);
    }

    @Override
    public LiveString asString() {
        return this;
    }

    @Override
    public String asStringValue() {
        return this.value;
    }

    @Override
    public LiveObject<?> asObject() {
        throw new ClassCastException("Cannot convert a string to an object");
    }

    @Override
    public StructuredObject asObjectValue() {
        throw new ClassCastException("Cannot convert a string to an object");
    }

    @Override
    public void setBool(boolean value) {
        this.set(Boolean.toString(value));
    }

    @Override
    public void setInt(int value) {
        this.set(Integer.toString(value));
    }

    @Override
    public void setLong(long value) {
        this.set(Long.toString(value));
    }

    @Override
    public void setFloat(float value) {
        this.set(Float.toString(value));
    }

    @Override
    public void setDouble(double value) {
        this.set(Double.toString(value));
    }

    @Override
    public void setString(String value) {
        this.set(value);
    }

    @Override
    public void setObject(StructuredObject value) {
        throw new ClassCastException("Cannot convert an object to a string");
    }
}

