/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.entitysyncer.structured.definition;

import org.openzen.entitysyncer.live.field.LiveField;
import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.structured.definition.BoolFieldType;
import org.openzen.entitysyncer.structured.definition.DoubleFieldType;
import org.openzen.entitysyncer.structured.definition.FloatFieldType;
import org.openzen.entitysyncer.structured.definition.IntFieldType;
import org.openzen.entitysyncer.structured.definition.LongFieldType;
import org.openzen.entitysyncer.structured.definition.ObjectFieldType;
import org.openzen.entitysyncer.structured.definition.StringFieldType;
import org.openzen.entitysyncer.structured.definition.StructuredFieldType;
import org.openzen.packetstreams.io.DataInput;
import org.openzen.packetstreams.io.DataOutput;

public class StructuredFieldDefinition {
    public final int id;
    public final String name;
    public final StructuredFieldType type;

    public StructuredFieldDefinition(int id, String name, StructuredFieldType type) {
        this.id = id;
        this.name = name;
        this.type = type;
    }

    public StructuredFieldDefinition(DataInput input) {
        this.id = input.readVarUInt();
        this.name = input.readString();
        this.type = StructuredFieldDefinition.readType(input);
    }

    public void read(LiveField field, StructuredDataInputStream input) {
        this.type.read(field, input);
    }

    private static StructuredFieldType readType(DataInput input) {
        int type = input.readVarUInt();
        switch (type) {
            case 1: {
                return BoolFieldType.INSTANCE;
            }
            case 2: {
                return IntFieldType.INSTANCE;
            }
            case 3: {
                return LongFieldType.INSTANCE;
            }
            case 4: {
                return FloatFieldType.INSTANCE;
            }
            case 5: {
                return DoubleFieldType.INSTANCE;
            }
            case 6: {
                return StringFieldType.INSTANCE;
            }
            case 7: {
                return new ObjectFieldType(input.readUUID());
            }
        }
        throw new RuntimeException("Invalid field type: " + type);
    }

    public void serialize(DataOutput output) {
        output.writeVarUInt(this.id);
        output.writeString(this.name);
        this.type.serialize(output);
    }
}

