/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.entitysyncer.structured.definition;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.openzen.entitysyncer.structured.definition.StructuredFieldDefinition;
import org.openzen.packetstreams.io.DataInput;
import org.openzen.packetstreams.io.DataOutput;

public class StructuredObjectClass {
    private static final UUID NO_SUPERCLASS = new UUID(0L, 0L);
    public final UUID id;
    public final UUID superclassId;
    private final StructuredFieldDefinition[] fields;
    private final Map<Integer, StructuredFieldDefinition> fieldsById = new HashMap<Integer, StructuredFieldDefinition>();

    public StructuredObjectClass(UUID id, UUID superclassId, StructuredFieldDefinition ... fields) {
        this.id = id;
        this.superclassId = superclassId;
        this.fields = fields;
        for (StructuredFieldDefinition field : fields) {
            this.fieldsById.put(field.id, field);
        }
    }

    public StructuredObjectClass(DataInput input) {
        this.id = input.readUUID();
        UUID superclass = input.readUUID();
        this.superclassId = superclass.equals(NO_SUPERCLASS) ? null : superclass;
        int numFields = input.readVarUInt();
        this.fields = new StructuredFieldDefinition[numFields];
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i] = new StructuredFieldDefinition(input);
            for (StructuredFieldDefinition field : this.fields) {
                this.fieldsById.put(field.id, field);
            }
        }
    }

    public StructuredFieldDefinition[] getFields() {
        return this.fields;
    }

    public StructuredFieldDefinition getField(int index) {
        return this.fieldsById.get(index);
    }

    public void serialize(DataOutput output) {
        output.writeUUID(this.id);
        output.writeUUID(this.superclassId == null ? NO_SUPERCLASS : this.superclassId);
        output.writeVarUInt(this.fields.length);
        for (StructuredFieldDefinition field : this.fields) {
            field.serialize(output);
        }
    }
}

