/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.live.field;

import java.util.UUID;
import org.openzen.entitysyncer.live.LiveBool;
import org.openzen.entitysyncer.live.LiveDouble;
import org.openzen.entitysyncer.live.LiveFloat;
import org.openzen.entitysyncer.live.LiveInt;
import org.openzen.entitysyncer.live.LiveLong;
import org.openzen.entitysyncer.live.LiveObject;
import org.openzen.entitysyncer.live.LiveObjectList;
import org.openzen.entitysyncer.live.LiveString;
import org.openzen.entitysyncer.live.LiveStringFunction;
import org.openzen.entitysyncer.live.LiveUUID;
import org.openzen.entitysyncer.live.Subscribable;
import org.openzen.entitysyncer.structured.StructuredObject;

/**
 *
 * @author Hoofdgebruiker
 */
public class LiveUUIDField extends Subscribable implements LiveField, LiveUUID {
	private UUID value;
	
	public LiveUUIDField(UUID value) {
		this.value = value;
	}
	
	@Override
	public UUID get() {
		return value;
	}
	
	public void set(UUID value) {
		this.value = value;
		publish();
	}

	@Override
	public void setBool(boolean value) {
		throw new ClassCastException("Cannot convert bool to uuid");
	}

	@Override
	public void setInt(int value) {
		throw new ClassCastException("Cannot convert int to uuid");
	}

	@Override
	public void setLong(long value) {
		throw new ClassCastException("Cannot convert long to uuid");
	}

	@Override
	public void setFloat(float value) {
		throw new ClassCastException("Cannot convert float to uuid");
	}

	@Override
	public void setDouble(double value) {
		throw new ClassCastException("Cannot convert double to uuid");
	}

	@Override
	public void setString(String value) {
		set(UUID.fromString(value));
	}
	
	@Override
	public void setUUID(UUID value) {
		set(value);
	}

	@Override
	public void setObject(StructuredObject value) {
		throw new ClassCastException("Cannot convert object to uuid");
	}

	@Override
	public LiveBool asBool() {
		throw new ClassCastException("Cannot convert uuid to bool");
	}

	@Override
	public boolean asBoolValue() {
		throw new ClassCastException("Cannot convert uuid to bool");
	}

	@Override
	public LiveInt asInt() {
		throw new ClassCastException("Cannot convert uuid to int");
	}

	@Override
	public int asIntValue() {
		throw new ClassCastException("Cannot convert uuid to int");
	}

	@Override
	public LiveLong asLong() {
		throw new ClassCastException("Cannot convert uuid to long");
	}

	@Override
	public long asLongValue() {
		throw new ClassCastException("Cannot convert uuid to long");
	}

	@Override
	public LiveFloat asFloat() {
		throw new ClassCastException("Cannot convert uuid to float");
	}

	@Override
	public float asFloatValue() {
		throw new ClassCastException("Cannot convert uuid to float");
	}

	@Override
	public LiveDouble asDouble() {
		throw new ClassCastException("Cannot convert uuid to double");
	}

	@Override
	public double asDoubleValue() {
		throw new ClassCastException("Cannot convert uuid to double");
	}

	@Override
	public LiveString asString() {
		return new LiveStringFunction(this::asStringValue, this);
	}

	@Override
	public String asStringValue() {
		return value.toString();
	}
	
	@Override
	public LiveUUID asUUID() {
		return this;
	}
	
	@Override
	public UUID asUUIDValue() {
		return value;
	}

	@Override
	public LiveObject<?> asObject() {
		throw new ClassCastException("Cannot convert uuid to object");
	}

	@Override
	public StructuredObject asObjectValue() {
		throw new ClassCastException("Cannot convert uuid to object");
	}

	@Override
	public LiveObjectList<?> asObjectList() {
		throw new ClassCastException("Cannot convert uuid to object list");
	}
}
