/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.entitysyncer.live.field;

import org.openzen.entitysyncer.live.LiveLong;
import org.openzen.entitysyncer.live.field.LiveBaseField;
import org.openzen.entitysyncer.structured.StructuredObject;

public class LiveLongField
extends LiveBaseField
implements LiveLong {
    private long value;

    public LiveLongField(long value) {
        this.value = value;
    }

    @Override
    public long get() {
        return this.value;
    }

    public void set(long value) {
        this.value = value;
        this.publish();
    }

    @Override
    public boolean asBoolValue() {
        return this.value != 0L;
    }

    @Override
    public int asIntValue() {
        return (int)this.value;
    }

    @Override
    public LiveLong asLong() {
        return this;
    }

    @Override
    public long asLongValue() {
        return this.value;
    }

    @Override
    public float asFloatValue() {
        return this.value;
    }

    @Override
    public double asDoubleValue() {
        return this.value;
    }

    @Override
    public String asStringValue() {
        return Long.toString(this.value);
    }

    @Override
    public StructuredObject asObjectValue() {
        throw new ClassCastException("Cannot cast int to an object");
    }

    @Override
    public void setBool(boolean value) {
        this.set(value ? 1L : 0L);
    }

    @Override
    public void setInt(int value) {
        this.set(value);
    }

    @Override
    public void setLong(long value) {
        this.set(value);
    }

    @Override
    public void setFloat(float value) {
        this.set((long)value);
    }

    @Override
    public void setDouble(double value) {
        this.set((long)value);
    }

    @Override
    public void setString(String value) {
        this.set(Long.parseLong(value));
    }

    @Override
    public void setObject(StructuredObject value) {
        throw new ClassCastException("Cannot cast object to long");
    }
}

