/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.live.field;

import org.openzen.entitysyncer.live.LiveByteArray;
import org.openzen.entitysyncer.structured.definition.ByteArrayFieldType;
import org.openzen.entitysyncer.structured.definition.StructuredFieldType;

/**
 *
 * @author Hoofdgebruiker
 */
public class LiveByteArrayField extends LiveBaseField implements LiveByteArray {
	private static final byte[] EMPTY = new byte[0];
	
	private byte[] value;
	
	public LiveByteArrayField() {
		this.value = EMPTY;
	}
	
	public LiveByteArrayField(byte[] value) {
		this.value = value;
	}
	
	@Override
	public byte[] get() {
		return value;
	}
	
	public void set(byte[] value) {
		this.value = value;
		publish();
	}
	
	@Override
	public void clear() {
		set(EMPTY);
	}
	
	@Override
	public StructuredFieldType getType() {
		return ByteArrayFieldType.INSTANCE;
	}
	
	@Override
	public void setByteArray(byte[] value) {
		set(value);
	}
	
	@Override
	public LiveByteArray asByteArray() {
		return this;
	}
	
	@Override
	public byte[] asByteArrayValue() {
		return value;
	}
}
