/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.live.field;

import java.util.UUID;
import org.openzen.entitysyncer.SimpleLocale;
import org.openzen.entitysyncer.live.LiveBool;
import org.openzen.entitysyncer.live.LiveByteArray;
import org.openzen.entitysyncer.live.LiveDouble;
import org.openzen.entitysyncer.live.LiveFloat;
import org.openzen.entitysyncer.live.LiveInt;
import org.openzen.entitysyncer.live.LiveLong;
import org.openzen.entitysyncer.live.LiveObject;
import org.openzen.entitysyncer.live.LiveObjectList;
import org.openzen.entitysyncer.live.LiveString;
import org.openzen.entitysyncer.live.LiveTranslatableString;
import org.openzen.entitysyncer.live.LiveUUID;
import org.openzen.entitysyncer.live.SubscribableList;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.structured.definition.ObjectFieldType;
import org.openzen.entitysyncer.structured.definition.StructuredFieldType;

/**
 *
 * @author Hoofdgebruiker
 */
public class LiveObjectField<T extends StructuredObject> extends SubscribableList implements LiveField, LiveObject<T> {
	private final ObjectFieldType type;
	private T value;
	
	public LiveObjectField(T value, ObjectFieldType type) {
		this.value = value;
		this.type = type;
	}
	
	@Override
	public T get() {
		return value;
	}
	
	public void set(T value) {
		this.value = value;
		publish();
	}
	
	@Override
	public void clear() {
		set(null);
	}
	
	@Override
	public StructuredFieldType getType() {
		return type;
	}

	@Override
	public void setObject(StructuredObject value) {
		set((T) value);
	}

	@Override
	public LiveObject<?> asObject() {
		return this;
	}

	@Override
	public StructuredObject asObjectValue() {
		return value;
	}
	
	@Override
	public void setBool(boolean value) {
		throw new ClassCastException("Cannot convert bool to " + getType());
	}

	@Override
	public void setInt(int value) {
		throw new ClassCastException("Cannot convert int to " + getType());
	}

	@Override
	public void setLong(long value) {
		throw new ClassCastException("Cannot convert long to " + getType());
	}

	@Override
	public void setFloat(float value) {
		throw new ClassCastException("Cannot convert float to " + getType());
	}

	@Override
	public void setDouble(double value) {
		throw new ClassCastException("Cannot convert double to " + getType());
	}

	@Override
	public void setString(String value) {
		throw new ClassCastException("Cannot convert string to " + getType());
	}
	
	@Override
	public void setUUID(UUID value) {
		throw new ClassCastException("Cannot convert uuid to " + getType());
	}
	
	@Override
	public void setByteArray(byte[] value) {
		throw new ClassCastException("Cannot convert byte[] to " + getType());
	}
	
	@Override
	public void setTranslation(SimpleLocale locale, String value) {
		throw new ClassCastException("This field is not a translatable string");
	}

	@Override
	public LiveBool asBool() {
		throw new ClassCastException("Cannot convert " + getType() + " to bool");
	}

	@Override
	public boolean asBoolValue() {
		throw new ClassCastException("Cannot convert " + getType() + " to bool");
	}

	@Override
	public LiveInt asInt() {
		throw new ClassCastException("Cannot convert " + getType() + " to int");
	}

	@Override
	public int asIntValue() {
		throw new ClassCastException("Cannot convert " + getType() + " to int");
	}

	@Override
	public LiveLong asLong() {
		throw new ClassCastException("Cannot convert " + getType() + " to long");
	}

	@Override
	public long asLongValue() {
		throw new ClassCastException("Cannot convert " + getType() + " to long");
	}

	@Override
	public LiveFloat asFloat() {
		throw new ClassCastException("Cannot convert " + getType() + " to float");
	}

	@Override
	public float asFloatValue() {
		throw new ClassCastException("Cannot convert " + getType() + " to float");
	}

	@Override
	public LiveDouble asDouble() {
		throw new ClassCastException("Cannot convert " + getType() + " to double");
	}

	@Override
	public double asDoubleValue() {
		throw new ClassCastException("Cannot convert " + getType() + " to double");
	}

	@Override
	public LiveString asString() {
		throw new ClassCastException("Cannot convert " + getType() + " to string");
	}

	@Override
	public String asStringValue() {
		throw new ClassCastException("Cannot convert " + getType() + " to string");
	}
	
	@Override
	public LiveUUID asUUID() {
		throw new ClassCastException("Cannot convert " + getType() + " to uuid");
	}
	
	@Override
	public UUID asUUIDValue() {
		throw new ClassCastException("Cannot convert " + getType() + " to uuid");
	}
	
	@Override
	public LiveByteArray asByteArray() {
		throw new ClassCastException("Cannot convert " + getType() + " to byte[]");
	}
	
	@Override
	public byte[] asByteArrayValue() {
		throw new ClassCastException("Cannot convert " + getType() + " to byte[]");
	}

	@Override
	public LiveObjectList<?> asObjectList() {
		throw new ClassCastException("Cannot convert " + getType() + " to object list");
	}
	
	@Override
	public LiveTranslatableString asTranslatableString() {
		throw new ClassCastException("Cannot convert " + getType() + " to a translatable string");
	}
}
