/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.live.field;

import java.util.EnumMap;
import java.util.Set;
import org.openzen.entitysyncer.SimpleLocale;
import org.openzen.entitysyncer.live.LiveTranslatableString;
import org.openzen.entitysyncer.structured.definition.StructuredFieldType;
import org.openzen.entitysyncer.structured.definition.TranslatableStringFieldType;

/**
 *
 * @author Hoofdgebruiker
 */
public class LiveTranslatableStringField extends LiveBaseField implements LiveTranslatableString {
	private final EnumMap<SimpleLocale, String> translations;
	
	public LiveTranslatableStringField(EnumMap<SimpleLocale, String> translations) {
		this.translations = translations;
	}
	
	public LiveTranslatableStringField() {
		this.translations = new EnumMap<>(SimpleLocale.class);
	}

	@Override
	public StructuredFieldType getType() {
		return TranslatableStringFieldType.INSTANCE;
	}

	@Override
	public String get(SimpleLocale locale) {
		do {
			String result = translations.get(locale);
			if (result != null)
				return null;
			
			locale = locale.generic;
		} while (locale != null);
		
		return translations.get(SimpleLocale.GENERIC);
	}

	@Override
	public void clear() {
		translations.clear();
		publish();
	}

	@Override
	public Set<SimpleLocale> getTranslationKeys() {
		return translations.keySet();
	}
}
