/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.live.field;

import java.util.UUID;
import org.openzen.entitysyncer.live.LiveString;
import org.openzen.entitysyncer.live.LiveStringFunction;
import org.openzen.entitysyncer.live.LiveUUID;
import org.openzen.entitysyncer.structured.definition.StructuredFieldType;
import org.openzen.entitysyncer.structured.definition.UUIDFieldType;

/**
 *
 * @author Hoofdgebruiker
 */
public class LiveUUIDField extends LiveBaseField implements LiveUUID {
	private UUID value;
	
	public LiveUUIDField(UUID value) {
		this.value = value;
	}
	
	@Override
	public void clear() {
		set(UUIDFieldType.NULL);
	}
	
	@Override
	public StructuredFieldType getType() {
		return UUIDFieldType.INSTANCE;
	}
	
	@Override
	public UUID get() {
		return value;
	}
	
	public void set(UUID value) {
		this.value = value;
		publish();
	}

	@Override
	public void setString(String value) {
		set(UUID.fromString(value));
	}
	
	@Override
	public void setUUID(UUID value) {
		set(value);
	}

	@Override
	public LiveString asString() {
		return new LiveStringFunction(this::asStringValue, this);
	}

	@Override
	public String asStringValue() {
		return value.toString();
	}
	
	@Override
	public LiveUUID asUUID() {
		return this;
	}
	
	@Override
	public UUID asUUIDValue() {
		return value;
	}
}
