/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.server;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.openzen.entitysyncer.EntitySyncerProtocol;
import org.openzen.entitysyncer.datasets.DatasetProvider;
import org.openzen.entitysyncer.datasets.DatasetSubscriber;
import org.openzen.entitysyncer.datasets.DatasetSubscription;
import org.openzen.packetstreams.BufferedServiceStream;
import org.openzen.packetstreams.crypto.CryptoPublicKey;
import org.openzen.packetstreams.io.BytesDataInput;
import org.openzen.packetstreams.io.BytesDataOutput;

/**
 *
 * @author Hoofdgebruiker
 */
public class EntitySyncerServerStream extends BufferedServiceStream {
	private final List<DatasetProvider> datasetProviders;
	private final CryptoPublicKey publicKey;
	
	private final List<DatasetSubscription> connections = new ArrayList<>();
	
	public EntitySyncerServerStream(List<DatasetProvider> datasetProviders, CryptoPublicKey publicKey) {
		this.datasetProviders = datasetProviders;
		this.publicKey = publicKey;
	}

	@Override
	public void writePacket(byte[] bytes) {
		BytesDataInput input = new BytesDataInput(bytes);
		switch (input.readVarUInt()) {
			case EntitySyncerProtocol.CLIENT_SERVER_CONNECT_DATASET_BY_ID: {
				int providerId = input.readVarUInt();
				if (providerId >= datasetProviders.size())
					break;
				
				long id = input.readVarULong();
				ServerSubscriber subscriber = new ServerSubscriber(connections.size());
				connections.add(datasetProviders
						.get(providerId)
						.getById(publicKey, id)
						.connect(subscriber));
				break;
			}
			case EntitySyncerProtocol.CLIENT_SERVER_CONNECT_DATASET_BY_UUID: {
				int providerId = input.readVarUInt();
				if (providerId >= datasetProviders.size())
					break;
				
				UUID uuid = input.readUUID();
				ServerSubscriber subscriber = new ServerSubscriber(connections.size());
				connections.add(datasetProviders.get(providerId)
						.getByUUID(publicKey, uuid)
						.connect(subscriber));
				break;
			}
			case EntitySyncerProtocol.CLIENT_SERVER_UPDATE_DATASET_BY_ID: {
				int providerId = input.readVarUInt();
				if (providerId >= datasetProviders.size())
					break;
				
				long id = input.readVarULong();
				byte[] version = input.readByteArray();
				ServerSubscriber subscriber = new ServerSubscriber(connections.size());
				connections.add(datasetProviders.get(providerId)
						.getById(publicKey, id)
						.connect(version, subscriber));
				break;
			}
			case EntitySyncerProtocol.CLIENT_SERVER_UPDATE_DATASET_BY_UUID: {
				int providerId = input.readVarUInt();
				if (providerId >= datasetProviders.size())
					break;
				
				UUID uuid = input.readUUID();
				byte[] version = input.readByteArray();
				ServerSubscriber subscriber = new ServerSubscriber(connections.size());
				connections.add(datasetProviders.get(providerId)
						.getByUUID(publicKey, uuid)
						.connect(subscriber));
				break;
			}
			case EntitySyncerProtocol.CLIENT_SERVER_DISCONNECT_DATASET: {
				int connectionId = input.readVarUInt();
				if (connectionId >= connections.size() || connections.get(connectionId) == null)
					break;
				
				connections.get(connectionId).close();
				break;
			}
		}
	}

	@Override
	public void onClosed() {
		for (DatasetSubscription connection : connections) {
			if (connection == null)
				continue;
			
			connection.close();
		}
	}
	
	private class ServerSubscriber implements DatasetSubscriber {
		public final int id;
		
		public ServerSubscriber(int id) {
			this.id = id;
		}

		@Override
		public void onNewState(byte[] version, byte[] state) {
			BytesDataOutput output = new BytesDataOutput();
			output.writeVarUInt(EntitySyncerProtocol.SERVER_CLIENT_PROVIDE_STATE);
			output.writeVarUInt(id);
			output.writeByteArray(version);
			output.writeByteArray(state);
			send(output.toByteArray());
		}

		@Override
		public void onUpdated(byte[] version, byte[] update) {
			BytesDataOutput output = new BytesDataOutput();
			output.writeVarUInt(EntitySyncerProtocol.SERVER_CLIENT_PROVIDE_UPDATE);
			output.writeVarUInt(id);
			output.writeByteArray(version);
			output.writeByteArray(update);
			send(output.toByteArray());
		}
	}
}
