/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.definition;

import org.openzen.entitysyncer.live.any.LiveAny;
import org.openzen.entitysyncer.live.field.LiveField;
import org.openzen.entitysyncer.live.field.LiveStringField;
import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.structured.StructuredDataOutputStream;
import org.openzen.packetstreams.io.DataOutput;

/**
 *
 * @author Hoofdgebruiker
 */
public class StringFieldType implements StructuredFieldType {
	public static final StringFieldType INSTANCE = new StringFieldType();
	
	private StringFieldType() {}

	@Override
	public LiveField create() {
		return new LiveStringField("");
	}

	@Override
	public void serialize(DataOutput output) {
		output.writeVarUInt(TYPE_STRING);
	}

	@Override
	public void read(LiveField field, StructuredDataInputStream input) {
		field.setString(input.input.readString());
	}

	@Override
	public void write(StructuredDataOutputStream output, LiveAny value) {
		output.output.writeString(value.asStringValue());
	}
}
