/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.definition;

import java.util.Set;
import org.openzen.entitysyncer.SimpleLocale;
import org.openzen.entitysyncer.live.LiveTranslatableString;
import org.openzen.entitysyncer.live.any.LiveAny;
import org.openzen.entitysyncer.live.field.LiveField;
import org.openzen.entitysyncer.live.field.LiveTranslatableStringField;
import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.structured.StructuredDataOutputStream;
import org.openzen.packetstreams.io.DataOutput;

/**
 *
 * @author Hoofdgebruiker
 */
public class TranslatableStringFieldType implements StructuredFieldType {
	public static final TranslatableStringFieldType INSTANCE = new TranslatableStringFieldType();
	
	private TranslatableStringFieldType() {}
	
	@Override
	public LiveField create() {
		return new LiveTranslatableStringField();
	}

	@Override
	public void read(LiveField field, StructuredDataInputStream input) {
		field.clear();
		
		int numTranslations = input.input.readVarUInt();
		for (int i = 0; i < numTranslations; i++) {
			SimpleLocale locale = SimpleLocale.get(input.input.readVarUInt());
			String value = input.input.readString();
			field.setTranslation(locale, value);
		}
	}

	@Override
	public void serialize(DataOutput output) {
		output.writeVarUInt(TYPE_TRANSLATABLE_STRING);
	}

	@Override
	public void write(StructuredDataOutputStream output, LiveAny value) {
		LiveTranslatableString translatableValue = value.asTranslatableString();
		Set<SimpleLocale> keys = translatableValue.getTranslationKeys();
		
		output.output.writeVarUInt(keys.size());
		for (SimpleLocale locale : translatableValue.getTranslationKeys()) {
			output.output.writeVarUInt(locale.ordinal());
			output.output.writeString(translatableValue.get(locale));
		}
	}
}
