/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.definition;

import java.util.UUID;
import org.openzen.entitysyncer.live.any.LiveAny;
import org.openzen.entitysyncer.live.field.LiveField;
import org.openzen.entitysyncer.live.field.LiveUUIDField;
import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.structured.StructuredDataOutputStream;
import org.openzen.packetstreams.io.DataOutput;

/**
 *
 * @author Hoofdgebruiker
 */
public class UUIDFieldType implements StructuredFieldType {
	public static final UUIDFieldType INSTANCE = new UUIDFieldType();
	public static final UUID NULL = new UUID(0, 0);
	
	private UUIDFieldType() {}

	@Override
	public LiveField create() {
		return new LiveUUIDField(NULL);
	}

	@Override
	public void serialize(DataOutput output) {
		output.writeVarUInt(TYPE_UUID);
	}

	@Override
	public void read(LiveField field, StructuredDataInputStream input) {
		field.setUUID(input.input.readUUID());
	}

	@Override
	public void write(StructuredDataOutputStream output, LiveAny value) {
		output.output.writeUUID(value.asUUIDValue());
	}
}
