/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.entitysyncer.live.field;

import org.openzen.entitysyncer.live.LiveInt;
import org.openzen.entitysyncer.live.field.LiveBaseNumberField;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.structured.definition.IntFieldType;
import org.openzen.entitysyncer.structured.definition.StructuredFieldType;

public class LiveIntField
extends LiveBaseNumberField
implements LiveInt {
    private int value;

    public LiveIntField(int value) {
        this.value = value;
    }

    @Override
    public int get() {
        return this.value;
    }

    public void set(int value) {
        this.value = value;
        this.publish();
    }

    @Override
    public void clear() {
        this.set(0);
    }

    @Override
    public StructuredFieldType getType() {
        return IntFieldType.INSTANCE;
    }

    @Override
    public boolean asBoolValue() {
        return this.value != 0;
    }

    @Override
    public LiveInt asInt() {
        return this;
    }

    @Override
    public int asIntValue() {
        return this.value;
    }

    @Override
    public long asLongValue() {
        return this.value;
    }

    @Override
    public float asFloatValue() {
        return this.value;
    }

    @Override
    public double asDoubleValue() {
        return this.value;
    }

    @Override
    public String asStringValue() {
        return Integer.toString(this.value);
    }

    @Override
    public StructuredObject asObjectValue() {
        throw new ClassCastException("Cannot cast int to an object");
    }

    @Override
    public void setBool(boolean value) {
        this.set(value ? 1 : 0);
    }

    @Override
    public void setInt(int value) {
        this.set(value);
    }

    @Override
    public void setLong(long value) {
        this.set((int)value);
    }

    @Override
    public void setFloat(float value) {
        this.set((int)value);
    }

    @Override
    public void setDouble(double value) {
        this.set((int)value);
    }

    @Override
    public void setString(String value) {
        this.set(Integer.parseInt(value));
    }

    @Override
    public void setObject(StructuredObject value) {
        throw new ClassCastException("Cannot cast object to int");
    }
}

