/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.live.field;

import org.openzen.entitysyncer.live.LiveBool;
import org.openzen.entitysyncer.live.LiveObject;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.structured.definition.BoolFieldType;
import org.openzen.entitysyncer.structured.definition.StructuredFieldType;

/**
 *
 * @author Hoofdgebruiker
 */
public class LiveBoolField extends LiveBaseNumberField implements LiveBool {
	private boolean value;
	
	public LiveBoolField(boolean value) {
		this.value = value;
	}
	
	@Override
	public boolean get() {
		return value;
	}
	
	public void set(boolean value) {
		this.value = value;
		publish();
	}
	
	@Override
	public void clear() {
		set(false);
	}
	
	@Override
	public StructuredFieldType getType() {
		return BoolFieldType.INSTANCE;
	}

	@Override
	public LiveBool asBool() {
		return this;
	}
	
	@Override
	public boolean asBoolValue() {
		return value;
	}
	
	@Override
	public int asIntValue() {
		return value ? 1 : 0;
	}
	
	@Override
	public long asLongValue() {
		return asIntValue();
	}

	@Override
	public float asFloatValue() {
		return asIntValue();
	}
	
	@Override
	public double asDoubleValue() {
		return asIntValue();
	}
	
	@Override
	public String asStringValue() {
		return Boolean.toString(value);
	}

	@Override
	public LiveObject<?> asObject() {
		throw new ClassCastException("Cannot convert a boolean to an object");
	}
	
	@Override
	public StructuredObject asObjectValue() {
		throw new ClassCastException("Cannot convert a boolean to an object");
	}
}
