/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.live.field;

import org.openzen.entitysyncer.live.LiveDouble;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.structured.definition.DoubleFieldType;
import org.openzen.entitysyncer.structured.definition.StructuredFieldType;

/**
 *
 * @author Hoofdgebruiker
 */
public class LiveDoubleField extends LiveBaseNumberField implements LiveDouble {
	private double value;
	
	public LiveDoubleField(double value) {
		this.value = value;
	}
	
	@Override
	public double get() {
		return value;
	}
	
	public void set(double value) {
		this.value = value;
		publish();
	}
	
	@Override
	public void clear() {
		set(0);
	}
	
	@Override
	public StructuredFieldType getType() {
		return DoubleFieldType.INSTANCE;
	}

	@Override
	public boolean asBoolValue() {
		return value != 0;
	}

	@Override
	public int asIntValue() {
		return (int) value;
	}

	@Override
	public long asLongValue() {
		return (long) value;
	}

	@Override
	public float asFloatValue() {
		return (float) value;
	}
	
	@Override
	public LiveDouble asDouble() {
		return this;
	}

	@Override
	public double asDoubleValue() {
		return value;
	}

	@Override
	public String asStringValue() {
		return Double.toString(value);
	}

	@Override
	public StructuredObject asObjectValue() {
		throw new ClassCastException("Cannot cast double to an object");
	}
}
