/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.live.field;

import org.openzen.entitysyncer.live.LiveLong;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.structured.definition.LongFieldType;
import org.openzen.entitysyncer.structured.definition.StructuredFieldType;

/**
 *
 * @author Hoofdgebruiker
 */
public class LiveLongField extends LiveBaseNumberField implements LiveLong {
	private long value;
	
	public LiveLongField(long value) {
		this.value = value;
	}
	
	@Override
	public long get() {
		return value;
	}
	
	@Override
	public void set(long value) {
		this.value = value;
		publish();
	}
	
	@Override
	public void clear() {
		set(0);
	}
	
	@Override
	public StructuredFieldType getType() {
		return LongFieldType.INSTANCE;
	}

	@Override
	public boolean asBoolValue() {
		return value != 0;
	}
	
	@Override
	public int asIntValue() {
		return (int) value;
	}
	
	@Override
	public LiveLong asLong() {
		return this;
	}

	@Override
	public long asLongValue() {
		return value;
	}

	@Override
	public float asFloatValue() {
		return value;
	}

	@Override
	public double asDoubleValue() {
		return value;
	}

	@Override
	public String asStringValue() {
		return Long.toString(value);
	}

	@Override
	public StructuredObject asObjectValue() {
		throw new ClassCastException("Cannot cast int to an object");
	}
}
